<?php

/**
 * This is the model class for table "SzkolenieFirmyOdp".
 *
 * The followings are the available columns in table 'SzkolenieFirmyOdp':
 * @property double $id
 * @property double $idSzkolenieFirmy
 * @property double $idZlecenia
 * @property string $odpowiedz
 * @property double $idOdpowiedzi
 */
class SzkolenieFirmyOdp extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SzkolenieFirmyOdp the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'SzkolenieFirmyOdp';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idSzkolenieFirmy, idZlecenia', 'required'),
			array('idSzkolenieFirmy, idZlecenia, idOdpowiedzi', 'numerical'),
			array('odpowiedz', 'length', 'max'=>40),

			array('id, idSzkolenieFirmy, idZlecenia, odpowiedz, idOdpowiedzi', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'szkolenieFirmy'=>array(self::BELONGS_TO, 'SzkolenieFirmy', 'idSzkolenieFirmy'),
			'zlecenie'=>array(self::BELONGS_TO, 'Zlecenie', 'idZlecenia'),
			'odpowiedz'=>array(self::BELONGS_TO, 'ZlecenieOdpowiedz', 'idOdpowiedzi'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('SzkolenieFirmyOdp', 'id'),
			'idSzkolenieFirmy'=>Yii::t('SzkolenieFirmyOdp', 'idSzkolenieFirmy'),
			'idZlecenia'=>Yii::t('SzkolenieFirmyOdp', 'idZlecenia'),
			'odpowiedz'=>Yii::t('SzkolenieFirmyOdp', 'odpowiedz'),
			'idOdpowiedzi'=>Yii::t('SzkolenieFirmyOdp', 'idOdpowiedzi'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idSzkolenieFirmy', $this->idSzkolenieFirmy);
		$criteria->compare('idZlecenia', $this->idZlecenia);
		$criteria->compare('odpowiedz', $this->odpowiedz, true);
		$criteria->compare('idOdpowiedzi', $this->idOdpowiedzi);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}